/**
 * The Student class keeps track of the following pieces of data
 * about a student: the student's name, ID number, and the number
 * of credits the student has earned toward graduation.
 * All of this information is entirely private to the class.
 * Clients can obtain this information only by using the various
 * methods defined by the class.
 */

public class Student {
	/* Private instance variables */
	private String studentName; /* The student's name         */
	private int studentID;      /* The student's ID number    */
	private double unitsEarned; /* The number of units earned */

	
	/**
	 * Creates a new Student object with the specified name and ID.
	 * @param name The student's name as a String
	 * @param id The student's ID number as an int
	 */
	public Student(String name, int id) {
		studentName = name;
		studentID = id;
	}

	/**
	 * Gets the name of this student.
	 * @return The name of this student
	 */
	public String getName() {
		return studentName;
	}

	/**
	 * Gets the ID number of this student.
	 * @return The ID number of this student
	 */
	public int getID() {
		return studentID;
	}

	/**
	 * Gets the number of units earned.
	 * @return The number of units this student has earned
	 */
	public double getUnits() {
		return unitsEarned;
	}
	
	/**
	 * Sets the number of units earned.
	 * @param units The new number of units earned
	 */
	public void setUnits(double units) {
		if (units >= 0) {
			unitsEarned = units;
		}
	}
		
	/**
	 * Creates a string identifying this student.
	 * @return The string used to display this student
	 */
	public String toString() {
		return studentName + " (#" + studentID + ")";
	}
}
